;*******************************
;*    DEMONTRATION PROGRAM 9   *
;*       ANALOG TO DIGITAL     *
;*******************************
;
            ORG    8000H
SYSCALL     EQU    30H
U25CTRL     EQU    0E0B3H
AD_OE       EQU    0E0A1H        ;Read CH#1
AD_ST       EQU    0E0A9H        ;Start CH#1
EOC         EQU    0E0B2H
DISBUF      EQU    9F00H
U21_CTRL    EQU    0E0BBH
U21PA       EQU    0E0B8H         ;D/A Port
U28CTRL     EQU    0E0B7H
U28PA       EQU    0E0B4H
CLRSCR      EQU    07             ;System call "clear screen"
DISP_DLY    EQU    0BH            ;System call "display & delay"
ON_TO_TWO   EQU    1DH            ;System call convert hex to seg.

START:      MOV    DPTR,#U25CTRL
            MOV    A,#9BH
            MOVX   @DPTR,A
            MOV    A,#80H
            MOV    DPTR,#U21_CTRL
            MOVX   @DPTR,A
            MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A

            MOV    A,#CLRSCR      ;Clear screen
            LCALL  SYSCALL
ST3:        MOV    DPTR,#AD_ST
            MOVX   @DPTR,A        ;Start A/D
            MOV    DPTR,#EOC
ST2:        MOVX   A,@DPTR
            JNB    ACC.7,ST2
            MOV    DPTR,#AD_OE
            MOVX   A,@DPTR
            MOV    B,A
            MOV    DPTR,#U21PA
            MOVX   @DPTR,A        ;Out to D/A
            MOV    A,#ON_TO_TWO
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF+2
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            MOV    B,#7FH
            MOV    A,#DISP_DLY    ;Display
            LCALL  SYSCALL
            SJMP   ST3
            END
